/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import javax.swing.JPanel;

public class SolarPanel
extends JPanel {
    private GUI gui = null;
    private Image photonImage = null;
    private Image elektronImage = null;
    private Image protonImage = null;
    private Image backgroundImage = null;
    private boolean sonne = false;
    private int size;

    public SolarPanel(GUI gui) {
        this.gui = gui;
        String currentDir = System.getProperty("user.dir");
        if (!currentDir.endsWith("\\")) {
            currentDir = String.valueOf(currentDir) + "\\";
        }
        Toolkit kit = Toolkit.getDefaultToolkit();
    }

    public void paintComponent(Graphics comp) {
        Font font;
        Graphics2D comp2D = (Graphics2D)comp;
        comp2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.size = (int)comp2D.getFont().getSize2D();
        comp2D.setColor(Color.white);
        comp2D.fillRect(0, 0, 500, 600);
        comp2D.drawString("Zeit", 10, 10);
        comp2D.setColor(Color.black);
        if (this.gui.getApplikationslogik().getAnzahlVector() != null) {
            font = new Font("Times New Roman", 0, (int)((double)this.size * 1.5));
            if (this.gui.getApplikationslogik().getAnzahlVector().size() > 0) {
                Anzahl currentAnzahl2 = this.gui.getApplikationslogik().getAnzahlVector().elementAt(0);
                comp2D.setFont(font);
                comp2D.drawString("Strom:", 10, 15);
                comp2D.drawString("Spannung:", 10, 40);
                comp2D.drawString("" + (int)((double)currentAnzahl2.getJ() * Math.pow(15.0, -2.0) * 3.0 * 1000.0), 220, 15);
                comp2D.drawString("mA", 260, 15);
                comp2D.drawString("mV", 260, 40);
                comp2D.drawString("W/m^2", 260, 65);
                comp2D.drawString("" + (int)((double)currentAnzahl2.getU() * Math.pow(200.0, -1.0) * 350.0), 220, 40);
                comp2D.drawString("Bestrahlungsst\u00e4rke:", 10, 65);
                comp2D.drawString("" + this.gui.getKonfigurationsPanel().getPhotonenProMinute() * 5, 220, 65);
                comp2D.drawString("Einfallswinkel:", 10, 90);
                comp2D.drawString(this.gui.getKonfigurationsPanel().getWinkel() + "\u00b0", 220, 90);
            }
        }
        comp2D.setColor(Color.blue);
        if (this.gui.getApplikationslogik().getAnzahlVector() != null) {
            int j = 20;
            while (j < this.gui.getApplikationslogik().getAnzahlVector().size() - 1) {
                Anzahl currentAnzahl = this.gui.getApplikationslogik().getAnzahlVector().elementAt(j);
                Anzahl currentAnzahl1 = this.gui.getApplikationslogik().getAnzahlVector().elementAt(j + 1);
                int i = j - 20;
                comp2D.setColor(Color.red);
                int a = 500 / this.gui.getApplikationslogik().getAnzahlVector().size();
                comp2D.drawLine(10 + i * a, 550 - currentAnzahl.getNgerundet(), 10 + (i + 1) * a, 550 - currentAnzahl1.getNgerundet());
                comp2D.setColor(Color.green);
                if (this.gui.getApplikationslogik().isSonne()) {
                    comp2D.drawLine(10 + i * a, 550 - currentAnzahl.getNsonnegerundet(), 10 + (i + 1) * a, 550 - currentAnzahl1.getNsonnegerundet());
                    comp2D.setColor(Color.red);
                }
                comp2D.setColor(Color.black);
                ++j;
            }
        }
        comp2D.setColor(Color.black);
        comp2D.drawLine(10, 170, 10, 550);
        comp2D.fillRect(0, 165, 500, 3);
        comp2D.drawLine(10, 550, 490, 550);
        font = new Font("Serif", 0, 20);
        comp2D.setFont(font);
        comp2D.drawString("Anzahl freier Elektronen", 10, 200);
        comp2D.drawString("Ort", 350, 520);
        comp2D.drawString("n-Gebiet", 20, 230);
        comp2D.drawString("p-Gebiet", 320, 230);
    }

    public void sonneAn() {
        this.sonne = true;
    }
}

