/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KonfigurationsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GUI gui = null;
    private JPanel photonenEinstellungen = null;
    private JPanel programmSteuerung = null;
    private JButton starteButton = null;
    private JButton neuStartButton = null;
    private JButton endeNeuButton = null;
    private int photonenProMinute = 20;
    private int geschwindigkeit = 10;

    public KonfigurationsPanel(GUI gui) {
        this.gui = gui;
        this.erstelleLayout();
    }

    private void erstelleLayout() {
        this.setSize(800, 150);
        this.setPreferredSize(new Dimension(800, 150));
        this.setBorder(new TitledBorder("Konfigurationsbereich"));
        this.setLayout(new GridLayout(1, 3));
        this.add(this.getPhotonenEinstellungen());
        this.add(this.getProgrammSteuerung());
    }

    public JPanel getPhotonenEinstellungen() {
        if (this.photonenEinstellungen == null) {
            this.photonenEinstellungen = new JPanel();
            this.photonenEinstellungen.setBorder(new TitledBorder("Photonen-Einstellungen"));
            this.photonenEinstellungen.setLayout(new GridLayout(2, 2));
            final JLabel photonenAnzahlLabel = new JLabel("Photonen pro Minute: " + this.photonenProMinute);
            final JLabel delayLabel = new JLabel("Geschwindigkeit: " + this.geschwindigkeit);
            final JSlider photonenAnzahlSlider = new JSlider();
            photonenAnzahlSlider.setMinimum(3);
            photonenAnzahlSlider.setMaximum(300);
            photonenAnzahlSlider.setMajorTickSpacing(20);
            photonenAnzahlSlider.setPaintTicks(true);
            photonenAnzahlSlider.setValue(this.photonenProMinute);
            photonenAnzahlSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    photonenAnzahlLabel.setText("Photonen pro Minute: " + photonenAnzahlSlider.getValue());
                    KonfigurationsPanel.this.photonenProMinute = photonenAnzahlSlider.getValue();
                }
            });
            final JSlider geschwindigkeitSlider = new JSlider();
            geschwindigkeitSlider.setMinimum(1);
            geschwindigkeitSlider.setMaximum(100);
            geschwindigkeitSlider.setMajorTickSpacing(5);
            geschwindigkeitSlider.setPaintTicks(true);
            geschwindigkeitSlider.setValue(this.geschwindigkeit);
            geschwindigkeitSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    delayLabel.setText("Geschwindigkeit: " + geschwindigkeitSlider.getValue());
                    KonfigurationsPanel.this.geschwindigkeit = geschwindigkeitSlider.getValue();
                }
            });
            this.photonenEinstellungen.add(photonenAnzahlLabel);
            this.photonenEinstellungen.add(photonenAnzahlSlider);
            this.photonenEinstellungen.add(delayLabel);
            this.photonenEinstellungen.add(geschwindigkeitSlider);
        }
        return this.photonenEinstellungen;
    }

    public JPanel getProgrammSteuerung() {
        if (this.programmSteuerung == null) {
            this.programmSteuerung = new JPanel();
            this.programmSteuerung.setBorder(new TitledBorder("Programmsteuerung"));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.programmSteuerung.setLayout(gridbag);
            this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
            constraints.anchor = 10;
            gridbag.setConstraints(this.getNeuStartButton(), constraints);
            this.programmSteuerung.add(this.getNeuStartButton());
            this.buildConstraints(constraints, 0, 1, 1, 1, 100, 100);
            constraints.anchor = 10;
            gridbag.setConstraints(this.getStarteButton(), constraints);
            this.programmSteuerung.add(this.getStarteButton());
            this.buildConstraints(constraints, 0, 2, 1, 1, 100, 100);
            constraints.anchor = 10;
            gridbag.setConstraints(this.getEndeNeuButton(), constraints);
            this.programmSteuerung.add(this.getEndeNeuButton());
        }
        return this.programmSteuerung;
    }

    public JButton getStarteButton() {
        if (this.starteButton == null) {
            this.starteButton = new JButton("  Starte   ");
            this.starteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    KonfigurationsPanel.this.gui.getApplikationslogik().starteGesamtProzedere();
                }
            });
        }
        return this.starteButton;
    }

    public JButton getNeuStartButton() {
        if (this.neuStartButton == null) {
            this.neuStartButton = new JButton("Neustart");
            this.neuStartButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    KonfigurationsPanel.this.gui.getApplikationslogik().neuStart();
                }
            });
        }
        return this.neuStartButton;
    }

    public JButton getEndeNeuButton() {
        if (this.endeNeuButton == null) {
            this.endeNeuButton = new JButton("   Ende    ");
            this.endeNeuButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    KonfigurationsPanel.this.gui.getApplikationslogik().beendeNeuGesamtProzedere();
                }
            });
        }
        return this.endeNeuButton;
    }

    public int getPhotonenProMinute() {
        return this.photonenProMinute;
    }

    public void setPhotonenProMinute(int photonenProMinutei) {
        this.photonenProMinute = photonenProMinutei;
    }

    public int getGeschwindigkeit() {
        return this.geschwindigkeit;
    }

    public void setGeschwindigkeit(int geschwindigkeiti) {
        this.geschwindigkeit = geschwindigkeiti;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }
}

